import type { Config } from "tailwindcss";

export default {
  content: [
    "./src/pages/**/*.{js,ts,jsx,tsx,mdx}",
    "./src/components/**/*.{js,ts,jsx,tsx,mdx}",
    "./src/app/**/*.{js,ts,jsx,tsx,mdx}",
  ],
  theme: {
    extend: {
      colors: {
        border: "hsl(var(--border))",
        background: "hsl(var(--background))",
        foreground: "hsl(var(--foreground))",
        primary: "var(--primary)",
        primaryMain: "var(--primaryMain)",
        primaryLight: "var(--primaryLight)",
        primaryLighter: "var(--primaryLighter)",
        primaryLightest: "var(--primaryLightest)",
        lightGreen: "var(--lightGreen)",
        lightGreenLight: "var(--lightGreenLight)",
        lightGreenLightest: "var(--lightGreenLightest)",
        grey: "var(--grey)",
        greyLight: "var(--greyLight)",
        greyDisabled: "var(--greyDisabled)",
        greyFill: "var(--greyFill)",
        greyLine: "var(--greyLine)",
        greyLineLight: "var(--greyLineLight)",
        greyStroke: "var(--greyStroke)",
        greySecondary: "var(--greySecondary)",
        blackMain: "var(--blackMain)",
        blackMain2: "var(--blackMain2)",
        accentWarning: "var(--accentWarning)",
        accentDanger: "var(--accentDanger)",
        accentRed: "var(--accentRed)",
        accentGreen: "var(--accentGreen)",
        accentCarrot: "var(--accentCarrot)",
        accentBrown: "var(--accentBrown)",
        accentBlue: "var(--accentBlue)",
        accentOrange: "var(--accentOrange)",
        whatsapp: "var(--whatsapp)",

        mainPrimary1: "var(--mainPrimary1)",
        mainPrimary2: "var(--mainPrimary2)",
        mainSecondary: "var(--mainSecondary)",
        mainTertiary: "var(--mainTertiary)",
        background1: "var(--background1)",
        background2: "var(--background2)",
        background3: "var(--background3)",
        background4: "var(--background4)",
        background5: "var(--background5)",
        backgroundAdmin1: "var(--backgroundAdmin1)",
        backgroundAdmin2: "var(--backgroundAdmin2)",
        backgroundAdmin3: "var(--backgroundAdmin3)",
        menuBackground: "var(--menuBackground)",
        menuHover: "var(--menuHover)",
        white: "var(--white)",
        whiteShade: "var(--whiteShade)",
        callGreyBg: "var(--callGreyBg)",
        callInactiveBg: "var(--callInactiveBg)",
        sidebar: {
          DEFAULT: "hsl(var(--sidebar-background))",
          foreground: "hsl(var(--sidebar-foreground))",
          primary: "hsl(var(--sidebar-primary))",
          "primary-foreground": "hsl(var(--sidebar-primary-foreground))",
          accent: "hsl(var(--sidebar-accent))",
          "accent-foreground": "hsl(var(--sidebar-accent-foreground))",
          border: "hsl(var(--sidebar-border))",
          ring: "hsl(var(--sidebar-ring))",
        },
      },
      backgroundImage: {
        buttonGradient:
          "linear-gradient(90deg, #2FA9B2 2.09%, #039CAD 36.85%, #02828F 100%)",
        aboutGradient:
          "linear-gradient(90deg, #2FA9B2 2.09%, #DCF2F4 40.85%, #DCF2F4 100%)",
      },
    },
    screens: {
      xs: "425px",
      sm: "600px",
      md: "768px",
      lg: "1024px",
      xl: "1280px",
    },
  },
  plugins: [],
} satisfies Config;
