import * as Yup from "yup";
import { isPossiblePhoneNumber } from "react-phone-number-input";

export const MANAGE_PATHOLOGIST_SCHEMA = Yup.object().shape({
  firstName: Yup.string().required("Please provide first name"),
  lastName: Yup.string().required("Please provider last name"),
  email: Yup.string()
    .required("Please enter your email")
    .email("Invalid Email"),
  type: Yup.string().required("Please select a Type"),
});

export const INSTITUTION_PROFILE_SCHEMA = Yup.object().shape({
  institutionName: Yup.string().required("Please provide institution name"),
  institutionType: Yup.string().required("Please select institution type"),
  institutionPhone: Yup.string()
    .required("Please enter your institutions number")
    .test("isValid", "Invalid phone number", (value) =>
      value ? isPossiblePhoneNumber(value) : false,
    ),
  institutionEmail: Yup.string()
    .required("Please enter institution's email")
    .email("Invalid Email"),
  institutionCountry: Yup.string().required(
    "Please provide institutions country",
  ),
  institutionAddress: Yup.string().required(
    "Please provide institutions address",
  ),
});
export const INSTITUTION_USER_PROFILE_SCHEMA = Yup.object().shape({
  firstName: Yup.string().required("Please provide first name"),
  lastName: Yup.string().required("Please provide last name"),
  phone: Yup.string()
    .required("Please enter your number")
    .test("isValid", "Invalid phone number", (value) =>
      value ? isPossiblePhoneNumber(value) : false,
    ),
  email: Yup.string()
    .required("Please enter your email")
    .email("Invalid Email"),
});

export const CHANGE_PASSWORD_SCHEMA = Yup.object().shape({
  oldPassword: Yup.string()
    .required("Please enter your old password")
    .min(6, "Password must contain 6 or more characters"),
  newPassword: Yup.string()
    .required("Please enter your new password")
    .min(6, "Password must contain 6 or more characters"),
  confirmPassword: Yup.string()
    .required("Please confirm your password")
    .oneOf([Yup.ref("newPassword"), ""], "Passwords must match"),
});

export const UPLOAD_SLIDE_SCHEMA = Yup.object().shape({
  slideName: Yup.string().required("Please enter slide name"),
  patientName: Yup.string().required("Please enter patient name"),
  modality: Yup.string().required("Please select modality"),
});

export const MANAGE_UPDATE_SLIDE_SCHEMA = Yup.object().shape({
  patientName: Yup.string().required("Please enter patient name"),
  modality: Yup.string().required("Please select modality"),
});

export const ADD_COMMENT_SCHEMA = Yup.object().shape({
  comment: Yup.string().required("Please give your opinion"),
});

export const MANAGE_SHARE_TO_EXTERNAL_SCHEMA = Yup.object().shape({
  name: Yup.string().required("Please provide pathologist name"),
  email: Yup.string()
    .required("Please enter pathologist email")
    .email("Invalid Email"),
  validity: Yup.number().required("Please provide validity period in minutes "),
  code: Yup.string().required("Please provide access code"),
  phone: Yup.string().test("isValid", "Invalid phone number", (value) =>
    value ? isPossiblePhoneNumber(value) : false,
  ),
});
