import * as Yup from "yup";

export const MANAGE_CONTACT_SCHEMA = Yup.object().shape({
  name: Yup.string().required("Please enter contact name"),
  email: Yup.string()
    .required("Please enter contact email")
    .email("Invalid Email"),
});

export const VISITOR_SCHEMA = Yup.object().shape({
  name: Yup.string().required("Please enter your first name"),
  email: Yup.string()
    .required("Please enter your email")
    .email("Invalid Email"),
  message: Yup.string().required("Please leave us a message"),
});
