import * as Yup from "yup";
import { isPossiblePhoneNumber } from "react-phone-number-input";

export const LOGIN_SCHEMA = Yup.object().shape({
  email: Yup.string()
    .required("Please enter your email")
    .email("Invalid Email"),
  password: Yup.string()
    .required("Please enter your password")
    .min(6, "Password must contain 6 or more characters"),
});

export const FORGOT_SCHEMA = Yup.object().shape({
  email: Yup.string()
    .required("Please enter your email")
    .email("Invalid Email"),
});

export const RESET_SCHEMA = Yup.object().shape({
  password: Yup.string()
    .required("Please enter your password")
    .min(6, "Password must contain 6 or more characters"),
  confirmPassword: Yup.string()
    .required("Please confirm your password")
    .oneOf([Yup.ref("password"), ""], "Passwords must match"),
});

export const VERIFY_SCHEMA = Yup.object().shape({
  email: Yup.string().required("Please enter your email"),
  otp: Yup.string()
    .required("Please enter your otp")
    .min(6, "Otp must be at least 6 characters")
    .max(6, "Otp must be max of 6 characters"),
});

export const REGISTER_PATHOLOGIST_ONE_SCHEMA = Yup.object().shape({
  firstName: Yup.string().required("Please enter your first name"),
  lastName: Yup.string().required("Please enter your last name"),
  email: Yup.string()
    .required("Please enter your email")
    .email("Invalid Email"),
  phone: Yup.string()
    .required("Please enter your phone number")
    .test("isValid", "Invalid phone number", (value) =>
      value ? isPossiblePhoneNumber(value) : false,
    ),
  country: Yup.string().required("Please provide country"),
  address: Yup.string().required("Please provide address"),
});

export const REGISTER_PATHOLOGIST_TWO_SCHEMA = Yup.object().shape({
  password: Yup.string()
    .required("Please enter your password")
    .min(6, "Password must contain 6 or more characters"),
  cPassword: Yup.string()
    .required("Please confirm your password")
    .oneOf([Yup.ref("password"), ""], "Passwords must match"),
});
export const REGISTER_ONE_SCHEMA = Yup.object().shape({
  institutionName: Yup.string().required("Please provide institution name"),
  institutionType: Yup.string().required("Please select institution type"),
  institutionPhone: Yup.string()
    .required("Please enter your institutions number")
    .test("isValid", "Invalid phone number", (value) =>
      value ? isPossiblePhoneNumber(value) : false,
    ),
  institutionEmail: Yup.string()
    .required("Please enter institution's email")
    .email("Invalid Email"),
  institutionCountry: Yup.string().required(
    "Please provide institutions country",
  ),
  institutionAddress: Yup.string().required(
    "Please provide institutions address",
  ),
});

export const REGISTER_TWO_SCHEMA = Yup.object().shape({
  firstName: Yup.string().required("Please enter your first name"),
  lastName: Yup.string().required("Please enter your last name"),
  email: Yup.string()
    .required("Please enter your email")
    .email("Invalid Email"),
  phone: Yup.string()
    .required("Please enter your phone number")
    .test("isValid", "Invalid phone number", (value) =>
      value ? isPossiblePhoneNumber(value) : false,
    ),
  password: Yup.string()
    .required("Please enter your password")
    .min(6, "Password must contain 6 or more characters"),
  cPassword: Yup.string()
    .required("Please confirm your password")
    .oneOf([Yup.ref("password"), ""], "Passwords must match"),
});

export const EXTERNAL_VIEWER_CONTROL_SCHEMA = Yup.object().shape({
  access: Yup.string().required("Please enter a valid access code"),
});

export const EXTERNAL_VIEWER_REPORT_SCHEMA = Yup.object().shape({
  opinion: Yup.string().required("Please provide your opinion"),
});
