export const getInitials = (name: string) => {
  if (!name) return "";

  const trimmedName = name.trim(); // Trim any leading or trailing spaces
  const names = trimmedName.split(" ").filter(Boolean); // Filter out empty parts
  let initials = "";

  // Limit the loop to the first two names
  for (let i = 0; i < Math.min(2, names.length); i++) {
    initials += names[i][0]?.toUpperCase();
  }

  return initials;
};
