export function formatSizeInBytes(sizeInBytes: number) {
  const ONE_GB = 1073741824; // 1024^3
  const ONE_MB = 1048576; // 1024^2

  if (sizeInBytes >= ONE_GB) {
    return `${(sizeInBytes / ONE_GB).toFixed(2)} GB`;
  } else if (sizeInBytes >= ONE_MB) {
    return `${(sizeInBytes / ONE_MB).toFixed(0)} MB`;
  } else {
    return `${sizeInBytes} Bytes`;
  }
}
