export function extractDimensions(
  url: string,
): { top: number; bottom: number } | null {
  const match = url.match(/_(\d+(\.\d+)?)x(\d+(\.\d+)?)\.png$/);
  if (!match) return null;

  const top = parseFloat(match[1]);
  const bottom = parseFloat(match[3]);

  return { top, bottom };
}
