import crypto from "crypto-js";

export function encrypt(data: any): string {
  const key = `${process.env.NEXT_PUBLIC_ENCRYPTION_KEY?.slice(12, 15)}-${process.env.NEXT_PUBLIC_ENCRYPTION_KEY?.slice(
    6,
    9,
  )}-${process.env.NEXT_PUBLIC_ENCRYPTION_KEY?.slice(0, 3)}`;

  if (typeof FormData !== "undefined" && data instanceof FormData) {
    const formDataObj: Record<string, any> = {};
    for (const [formKey, value] of data.entries()) {
      formDataObj[formKey] = value;
    }
    data = formDataObj;
  }

  const encrypted = crypto.AES.encrypt(JSON.stringify(data), key).toString();
  return encrypted;
}

export function decrypt<T = any>(data: string): T {
  const key = `${process.env.NEXT_PUBLIC_ENCRYPTION_KEY?.slice(12, 15)}-${process.env.NEXT_PUBLIC_ENCRYPTION_KEY?.slice(
    6,
    9,
  )}-${process.env.NEXT_PUBLIC_ENCRYPTION_KEY?.slice(0, 3)}`;

  const decryptedBytes = crypto.AES.decrypt(data, key);
  const decryptedStr = decryptedBytes.toString(crypto.enc.Utf8);
  return JSON.parse(decryptedStr);
}
