export const copyString = (text: string) => {
  if (navigator.clipboard && window.isSecureContext) {
    // Modern method
    return navigator.clipboard.writeText(text);
  } else {
    // Fallback for older browsers
    const textarea = document.createElement("textarea");
    textarea.value = text;
    textarea.style.position = "fixed"; // Prevent scrolling to bottom of page
    document.body.appendChild(textarea);
    textarea.focus();
    textarea.select();
    try {
      document.execCommand("copy");
    } catch (err) {
      console.error("Failed to copy: ", err);
    }
    document.body.removeChild(textarea);
    return Promise.resolve();
  }
};
