import { User, UserRole } from "@/interfaces";

export const setToken = (token: string) => {
  sessionStorage.removeItem("xpToken");
  sessionStorage.setItem("xpToken", token);
};

export function getToken() {
  if (typeof window === "undefined") {
    // Prevent server-side execution
    return null;
  }
  const token = sessionStorage.getItem("xpToken");

  if (token) return token;
  else return null;
}

export const setAuthEmail = (email: string) => {
  sessionStorage.removeItem("authEmail");
  sessionStorage.setItem("authEmail", email);
};

export function getAuthEmail() {
  if (typeof window === "undefined") {
    // Prevent server-side execution
    return null;
  }

  const email = sessionStorage.getItem("authEmail");

  if (email) return email;
  return null;
}

export const setSessionUserData = (data: User) => {
  const userData = JSON.stringify(data);
  sessionStorage.removeItem("xpUser");
  sessionStorage.setItem("xpUser", userData);
};

export const getUserData = (): User | null => {
  if (typeof window === "undefined") return null;
  const storedUser = sessionStorage.getItem("xpUser");
  return storedUser ? JSON.parse(storedUser) : null;
};

export const setSessionActiveBranchId = (id: number) => {
  if (typeof window !== "undefined") {
    sessionStorage.setItem("xpActiveBranch", String(id));
  }
};

export const getSessionActiveBranchId = () => {
  if (typeof window === "undefined") return null;
  const id = sessionStorage.getItem("xpActiveBranch");
  return id ? Number(id) : null;
};

export const setSessionActiveInstitutionId = (id: number) => {
  if (typeof window !== "undefined") {
    sessionStorage.setItem("xpActiveInstitution", String(id));
  }
};

export const getSessionActiveInstitutionId = () => {
  if (typeof window === "undefined") return null;
  const id = sessionStorage.getItem("xpActiveInstitution");
  return id ? Number(id) : null;
};

export const setSessionActiveRole = (role: UserRole) => {
  if (typeof window !== "undefined") {
    sessionStorage.setItem("xpActiveRole", role);
  }
};

export const getSessionActiveRole = (): UserRole | null => {
  if (typeof window === "undefined") return null;
  return (sessionStorage.getItem("xpActiveRole") as UserRole) || null;
};
