import { User } from "@/interfaces";
import env from "../../env";
import { request } from "./api";

const { API_URL } = env;

const URL = {
  user: `${API_URL}/users`,
  pathologistAccept: `${API_URL}/institution-pathologists/accept-invitation`,
};

function getUserDetails() {
  return request<User>(`${URL.user}/me`, {}, "GET");
}

function acceptPathologistInvite({
  invitationRef,
  email,
}: {
  invitationRef: string;
  email: string;
}) {
  return request(URL.pathologistAccept, { invitationRef, email }, "POST");
}

function sendVisitorsMessage(body: {
  name: string;
  email: string;
  message?: string;
  subject?: string;
}) {
  return request(`${URL.user}/visitors_message`, body, "POST");
}

function sendRealTImeLink({ link }: { link: string }) {
  return request(`${URL.user}/send-meeting-link`, { link }, "POST");
}

const userService = {
  getUserDetails,
  acceptPathologistInvite,
  sendVisitorsMessage,
  sendRealTImeLink,
};

export default userService;
