import axios from "axios";
import env from "../../env";
import { request } from "./api";

const { API_URL } = env;

const URL = {
  institution: `${API_URL}/institutions`,
};

const axiosClient = axios.create({
  baseURL: API_URL,
  headers: {
    Accept: "*/*",
    "Content-Type": "application/json",
    // Authorization: `Basic ${credentials}`,
  },
});

const getOrtStudyDetail = (orthancStudyId: string) => {
  return axiosClient.get(`studies/${orthancStudyId}?requestedTags=Modality`);
};

const uploadStudy = async (binaryData: any) => {
  return axiosClient.post(`instances`, binaryData, {
    headers: { "Content-Type": "multipart/form-data" },
  });
};

const orthancService = {
  getOrtStudyDetail,
  uploadStudy,
};

export default orthancService;
