import axios from "axios";

const JITSI_TOKEN_API = "/api/jitsi-token"; // Replace with actual endpoint if different

export async function getJitsiJwt({
  firstName,
  lastName,
  email,
  meetingId,
  userId,avatar
}: {
  firstName: string;
  lastName: string;
  email: string;
  meetingId: string;
  userId: string;
  avatar?: string; // Optional avatar field
}): Promise<string> {
  const response = await axios.post(JITSI_TOKEN_API, {
    username:`${firstName} ${lastName}`,
    email,
    room:meetingId,
    userId,
    avatar
  });
  return response.data?.token;
}
