import env from "../../env";
import { request } from "./api";

const { API_URL } = env;

const URL = {
  institution: `${API_URL}/institutions`,
};

function uploadStatusInst({
  fileName,
  fileId,
  data,
  institutionId,
  branchId,
  studiesDateTime,
}: {
  fileName: string;
  fileId?: string | number;
  institutionId: number;
  studiesDateTime: string;
  branchId?: number;
  data: any;
}) {
  return request(
    `${URL.institution}/${institutionId}/file-upload/upload-status`,
    { fileName, fileId, data, branchId, studiesDateTime },
    "POST",
  );
}

const fileService = {
  uploadStatusInst,
};

export default fileService;
