import { CaMicroscopeDataPayload } from "@/interfaces";
import env from "../../env";
import { request } from "./api";

const { CAMICROSCOPE_BASE_URL } = env;

const URL = {
  startUpload: `${CAMICROSCOPE_BASE_URL}/loader/upload/start`,
  uploadChunk: (fileId: string) =>
    `${CAMICROSCOPE_BASE_URL}/loader/upload/continue/${fileId}`,
  finishUplad: (fileId: string) =>
    `${CAMICROSCOPE_BASE_URL}/loader/upload/finish/${fileId}`,
  getUploadedMetadata: (fileName: string) =>
    `${CAMICROSCOPE_BASE_URL}/loader/data/one/${fileName}`,
  finalUploadSlideData: `${CAMICROSCOPE_BASE_URL}/data/Slide/post`,
};

function startUpload(body: { filename: string }) {
  return request(`${URL.startUpload}`, body, "POST");
}

function uploadChunk(
  uploadingFileId: string,
  body: { chunkSize: number; data: string; offset: number },
) {
  return request(`${URL.uploadChunk(uploadingFileId)}`, body, "POST");
}

function finishUpload(uploadingFileId: string, body: { filename: string }) {
  return request(`${URL.finishUplad(uploadingFileId)}`, body, "POST");
}

function getUploadedMetadata(fileName: string) {
  return request(`${URL.getUploadedMetadata(fileName)}`, {}, "GET");
}

function finalUploadSlideData(body: CaMicroscopeDataPayload) {
  return request(`${URL.finalUploadSlideData}`, body, "POST");
}

const camicroscopeService = {
  startUpload,
  uploadChunk,
  finishUpload,
  getUploadedMetadata,
  finalUploadSlideData,
};

export default camicroscopeService;
