import { User } from "@/interfaces";
import env from "../../env";
import { request } from "./api";

const { API_URL } = env;

const URL = {
  auth: `${API_URL}/auth`,
};

function login(body: { email: string; password: string }) {
  return request<{ token?: string }>(`${URL.auth}/login`, body, "POST");
}

function forgotPassword(email: string) {
  return request(`${URL.auth}/forgotPassword`, { email }, "POST");
}

function createInstitution(body: {
  institutionName: string;
  registerationNumber?: string;
  institutionType?:
    | "MEDICAL_CENTER"
    | "DIAGNOSTIC_CENTER"
    | "HOSPITAL"
    | "GROUP_OF_RADIOLOGISTS"
    | "OTHERS";
  institutionEmail: string;
  institutionPhone: {
    phoneCode: string;
    phoneNumber: string;
  };
  institutionCountry: string;
  institutionAddress: string;
  firstName: string;
  lastName: string;
  phone: {
    phoneCode: string;
    phoneNumber: string;
  };
  email: string;
  password: string;
}) {
  return request(`${URL.auth}/institution/signup`, body, "POST");
}

function createPathologist(body: {
  firstName: string;
  lastName: string;
  phone: {
    phoneCode: string;
    phoneNumber: string;
  };
  email: string;
  password: string;
  country: string;
  address: string;
}) {
  return request(`${URL.auth}/pathologist/signup`, body, "POST");
}

function verifySignUp({ email, otp }: { email: string; otp: string }) {
  return request(`${URL.auth}/verifySignUpEmail`, { email, otp }, "POST");
}

function resendVerifySignup({ email }: { email: string }) {
  return request(`${URL.auth}/resendEmailOtp`, { email }, "GET");
}

function verifyResetOtp({ email, otp }: { email: string; otp: string }) {
  return request(
    `${URL.auth}/verifyResetPasswordOtp`,
    { email, resetOtp: otp },
    "POST",
  );
}
function resetPassword(body: {
  email: string;
  password: string;
  confirmPassword: string;
}) {
  return request(`${URL.auth}/resetPassword`, body, "POST");
}

function changePassword(body: { oldPassword: string; newPassword: string }) {
  return request(`${URL.auth}/changePassword`, body, "POST");
}

const authService = {
  login,
  forgotPassword,
  createInstitution,
  verifySignUp,
  resendVerifySignup,
  verifyResetOtp,
  resetPassword,
  changePassword,
  createPathologist,
};

export default authService;
