import {
  Institution,
  InstitutionAdmin,
  Permissions,
  User,
  UserRole,
} from "@/interfaces";
import { createSlice, PayloadAction } from "@reduxjs/toolkit";

interface UserState {
  activeUser: User | null;
  activeInstitution: Institution | null;
  activeRole: UserRole | null;
  permissions: Permissions | null;
  institutionAdmin: InstitutionAdmin | null;
  contacts: unknown[];
}

const initialState: UserState = {
  activeUser: null,
  activeInstitution: null,
  activeRole: null,
  permissions: null,
  institutionAdmin: null,
  contacts: [],
};

const userSlice = createSlice({
  name: "user",
  initialState,
  reducers: {
    setActiveUser(state, action: PayloadAction<User | null>) {
      state.activeUser = action.payload;
    },

    setActiveInstitution(state, action: PayloadAction<Institution | null>) {
      state.activeInstitution = action.payload;
    },

    setPermissions(state, action: PayloadAction<Permissions | null>) {
      state.permissions = action.payload;
    },

    setInstitutionAdmin(state, action: PayloadAction<InstitutionAdmin | null>) {
      state.institutionAdmin = action.payload;
    },
    setActiveRole(state, action: PayloadAction<UserRole | null>) {
      state.activeRole = action.payload;
    },

    setUserContacts(state, action: PayloadAction<unknown[]>) {
      state.contacts = action.payload;
    },

    logout(state) {
      state.activeUser = null;
      state.activeInstitution = null;
      state.activeRole = null;
      state.permissions = null;
      state.institutionAdmin = null;
      sessionStorage.removeItem("xpUser");
      sessionStorage.removeItem("xpToken");
      sessionStorage.removeItem("authEmail");
      sessionStorage.removeItem("xpActiveBranch");
      sessionStorage.removeItem("xpActiveInstitution");
      sessionStorage.removeItem("xpActiveRole");
    },
  },
});

export const {
  setActiveUser,
  setActiveInstitution,
  setPermissions,
  setInstitutionAdmin,
  setActiveRole,
  setUserContacts,
  logout,
} = userSlice.actions;

export default userSlice.reducer;
