import { configureStore } from "@reduxjs/toolkit";
import globalSlice from "@/redux/global/globalSlice";
import userSlice from "@/redux/user/userSlice";
import dataSlice from "@/redux/data/dataSlice";
import callSlice from "@/redux/call/callSlice";

const store = configureStore({
  reducer: {
    global: globalSlice,
    user: userSlice,
    data: dataSlice,
    call: callSlice,
  },
});

// Export types for use with hooks
export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;

export default store;
