import { createSlice, PayloadAction } from "@reduxjs/toolkit";

interface DataState {
  slides: any[];
  sharedSlides: any[];
  slideDetail: any;
  pathologists: any[];
  dashboard: {
    distribution: any[];
    statistic: any;
    dash: any;
  };
  externalViewerData: any;
}

const initialState: DataState = {
  slides: [],
  sharedSlides: [],
  slideDetail: {},
  pathologists: [],
  dashboard: {
    distribution: [],
    statistic: {},
    dash: {},
  },
  externalViewerData: {},
};

const dataSlice = createSlice({
  name: "data",
  initialState,
  reducers: {
    setSlides: (state, action: PayloadAction<any[]>) => {
      state.slides = action.payload;
    },
    setSharedSlides: (state, action: PayloadAction<any[]>) => {
      state.sharedSlides = action.payload;
    },
    setSlideDetail: (state, action: PayloadAction<any>) => {
      state.slideDetail = action.payload;
    },
    setPathologists: (state, action: PayloadAction<any[]>) => {
      state.pathologists = action.payload;
    },
    setDashboard: (
      state,
      action: PayloadAction<{ distribution: any[]; statistic: any; dash: any }>,
    ) => {
      state.dashboard = {
        distribution: action.payload.distribution,
        statistic: action.payload.statistic,
        dash: action.payload.dash,
      };
    },
    setExternalViewerData: (state, action: PayloadAction<any>) => {
      state.externalViewerData = action.payload;
    },
  },
});

export const {
  setSlides,
  setSharedSlides,
  setSlideDetail,
  setPathologists,
  setDashboard,
  setExternalViewerData,
} = dataSlice.actions;

export default dataSlice.reducer;
