export interface Pathologist {
  id?: number;
  type?: "CONSULTANT" | "RESIDENT";
  verified?: boolean;
  status?: string;
  user: User;
}

export interface User {
  address: string | null;
  availability: boolean;
  country: string | null;
  createdAt: Date;
  dob: string | null;
  email: string;
  firstName: string;
  gender: string | null;
  id: string;
  lastName: string;
  onlineStatus: boolean;
  pathologist: null | Pathologist;
  peerId: string | null;
  phoneCode: string;
  phoneNumber: string;
  profileImage: string | null;
  refId: string;
  role: "USER";
  state: string | null;
  status: "active";
  twoFAEnabled: boolean;
  verified: boolean;
  userInstitutions?: UserInstitutions;
}

export interface Institution {
  address: string | null;
  canCreateOffer: boolean;
  city: string | null;
  country: string | null;
  createdAt: Date;
  entityInitialOnReport: "PRACTITIONER" | "PATHOLOGIST" | "INSTITUTION";
  freeTrialDays: string | number | null;
  hasAssignedAStudy: boolean;
  id: number;
  institutionEmail: string;
  institutionName: string;
  institutionPlan: "ACCESS" | "RADOPS";
  institutionType:
    | "MEDICAL_CENTER"
    | "DIAGNOSTIC_CENTER"
    | "HOSPITAL"
    | "GROUP_OF_RADIOLOGISTS"
    | "OTHERS";
  localStudiesSync: boolean;
  logo: string | null;
  othersPayForInterpretation: boolean;
  phoneCode: string;
  phoneNumber: string;
  state: string | null;
  verified: boolean;
  website: string | null;
  xolaniDriveExpiryDate: string | null;
  letterHead: string | null;
}

export type UserRole = "SUPERADMIN" | "ADMIN" | "PATHOLOGIST";
export interface UserInstitution {
  role: UserRole;
  institution: Institution;
}

export type UserInstitutions = UserInstitution[];

export interface InstitutionAdmin {
  id: number;
  invitationStatus: string;
  lastCheckIn: Date;
  role: "SUPERADMIN" | "ADMIN";
  status: string;
}

export interface Permissions {
  access_dashboard: boolean;
  access_images: boolean;
  access_pathologists: boolean;
}

export interface CaMicroscopeDataUpload {
  width: string;
  height: string;
  mppX: string;
  mppY: string;
  vendor: string;
  levelCount: number;
  objective: number;
  comment: string;
  study: string;
  specimen: string;
  md5: string;
  location: string;
  filepath: string;
  uploadDate: string;
  name: string;
  camSlideId: string;
  fileName: string;
  fileToken: string;
}

export interface CaMicroscopeDataPayload {
  width: string;
  height: string;
  mppX?: string;
  mppY?: string;
  "mpp-x"?: string;
  "mpp-y"?: string;
  mpp_x?: string | number;
  mpp_y?: string | number;
  mpp?: string | number;
  vendor: string;
  level_count: number;
  objective: number;
  comment: string;
  study: string;
  specimen: string;
  md5: string;
  location: string;
  filepath: string;
  upload_date: string;
  name: string;
  _id?: string;
  fileName?: string;
}

export type modalityTypes = "SM" | "GM" | "ES" | "OP" | "XC";
export interface UploadSlideData {
  slideImageHost: "camicroscope" | "orthanc";
  patientName: string;
  name: string;
  modality: modalityTypes | string;
  comment: string;
  fileSize: number;
  caMicroscopeData: CaMicroscopeDataUpload;
}

export interface Report {
  id: number;
  concluded: boolean;
  destination: string;
  diagnosis: string;
  file: string;
  impressions: string;
  microscopy: string;
  pathologist_microscopy: any[];
  pathologist: Pathologist;
  pathologistSharedWith: Pathologist;
  recommendations: string;
  secondOpinion: string | null;
  externalOpinion: string | null;
  status: "approved" | "pending" | "rejected" | string;
}

export interface Study {
  id: string;
  assignedAt: null | string;
  comment: string | null;
  createdAt: string | number | null;
  fileId: null | string;
  fileName: string;
  fileSize: number | null;
  inReviewAt: null;
  modality: string | null;
  name: string;
  paidForUpload: boolean;
  patientName: string;
  reportedAt: null | string;
  slideImageHost: string;
  status: string;
  statusTime: string | null;
  uploadFee: number;
  uploadId: number | number;
  uploadProgress: string;
  uploadStatus: string | null;
}

export interface ExternalPathologistViewer {
  reportId: number;
  shareId: number;
  verified: boolean;
  report: Report;
}
