export {};

declare global {
  interface Window {
    SpeechRecognition?: new () => SpeechRecognition;
    webkitSpeechRecognition?: new () => SpeechRecognition;
  }

  interface Window {
    stream?: MediaStream | null;
  }

  interface SpeechRecognition extends EventTarget {
    continuous: boolean;
    interimResults: boolean;
    lang: string;
    start(): void;
    stop(): void;
    onstart?: () => void;
    onend?: () => void;
    onresult?: (event: SpeechRecognitionEvent) => void;
  }

  interface SpeechRecognitionEvent extends Event {
    results: {
      [index: number]: {
        [index: number]: {
          transcript: string;
        };
      };
    };
  }

  // types/global.d.ts
  interface MediaTrackConstraintSet {
    cursor?: ConstrainDOMString;
    displaySurface?: ConstrainDOMString;
    logicalSurface?: ConstrainBoolean;
  }

  interface DisplayMediaStreamConstraints {
    video?:
      | boolean
      | (MediaTrackConstraints & {
          cursor?: ConstrainDOMString;
          displaySurface?: ConstrainDOMString;
          logicalSurface?: ConstrainBoolean;
        });
    audio?: boolean | MediaTrackConstraints;
  }

  interface Window {
    smartlook: (...args: any[]) => void;
  }
}
