export interface UploadingFile {
  file: File;
  fileSize?: number;
  status?: FileStatusEnum;
  formattedFileName?: string;
  uploadingFileId: string;
  chunkNumber?: number;
  fileSizeUploaded?: number;
}

export enum FileStatusEnum {
  UPLOADING = "uploading",
  PAUSED = "paused",
  COMPLETED = "completed",
  FAILED = "failed",
  PROCESSING = "processing",
  PROCESSING_FAILED = "processing_failed",
  QUEUED = "queued",
  UPLOAD_FAILED = "upload_failed",
}

export interface ChunkUploadOptions {
  fileId: string;
  startingByte: number;
  data: FileUploadData[];
  chunkNumber?: number;
}

export interface FileUploadData {
  originalFileName: string;
  fileSize: number;
  fileName: string;
  patientName?: string;
  modality?: string;
  studyDescription?: string;
  studyDate?: string;
  studyTime?: string;
  studyInstanceUID?: string;
}
