import React from "react";
import Image from "next/image";
import SuccessIcon from "@/assets/icons/icons8-success-96.svg";

const SuccessPrompt = ({ body }: { body: string }) => {
  return (
    <div className="w-[300px] rounded-lg bg-white p-10">
      <div className="flex justify-center">
        <Image
          src={SuccessIcon}
          alt="success"
          className="h-[100px] w-[100px]"
        />
      </div>
      <div className="relative">
        <p className="pb-8 pt-4 text-center text-lg font-medium text-greySecondary">
          {body}
        </p>
      </div>
    </div>
  );
};

export default SuccessPrompt;
