import React from "react";
import { Button } from "../../Buttons";
import { User } from "@/interfaces";
import usePathologists from "@/app/institution/pathologists/hooks/usePathologists";
import { useSelector } from "react-redux";
import { RootState } from "@/redux/store";
import Loading from "@/components/Loading/Loading";

interface Props {
  widthSize?: string;
  onClose: () => void;
  user: {
    id: number;
    verified: boolean;
    createdAt: Date | string;
    user: User;
    type: string;
  };
}

const RemovePathologist = ({ widthSize, onClose, user }: Props) => {
  const loading = useSelector((state: RootState) => state.global.promptLoading);
  const { removePathologist } = usePathologists();

  const handleProceed = async () => {
    removePathologist(user.id);
  };

  return (
    <div
      style={{ width: widthSize ? widthSize : "450px" }}
      className="relative rounded-lg bg-white"
    >
      {/* {loading && (
        <Loading
          className={{
            body: "bg-black/25",
            loader: "!w-[40px]",
          }}
        />
      )} */}
      <div className={`relative px-10 pt-12`}>
        <h4 className={`w-full text-center text-2xl font-medium text-grey`}>
          Remove Pathologist?
        </h4>

        <p className={`mb-6 py-8 text-center font-medium text-greySecondary`}>
          {`This action will remove ${user?.user?.firstName || ""} ${user?.user?.lastName || ""} from your Pathologists. Click 'Remove' to proceed.`}
        </p>
      </div>
      <div className="flex justify-between border-t-2 border-greyStroke px-10 py-6">
        <Button
          variant="gray"
          onClick={() => {
            onClose();
          }}
        >
          Cancel
        </Button>
        <Button
          disabled={loading}
          loading={loading}
          variant="primary"
          onClick={handleProceed}
        >
          {loading ? `Removing...` : "Remove"}
        </Button>
      </div>
    </div>
  );
};

export default RemovePathologist;
