import React from "react";
import { Button } from "../../Buttons";
import { MdOutlineClose } from "react-icons/md";

interface Props {
  widthSize?: string;
  onClose: () => void;
  title?: string;
  bodyText: string;
  buttonText: string;
  onProceed?: () => void;
}

const Prompt = ({
  widthSize,
  onClose,
  title,
  bodyText,
  buttonText,
  onProceed,
}: Props) => {
  const loading: boolean = false;

  const handleProceed = async () => {
    if (!onProceed) return;

    onProceed();
  };
  return (
    <div
      style={{ width: widthSize ? widthSize : "450px" }}
      className="rounded-lg bg-white"
    >
      <div
        className={`relative px-10 pt-12 ${!title ? "flex h-[200px] items-center justify-center" : ""}`}
      >
        {title && (
          <h4 className={`w-full text-center text-2xl font-medium text-grey`}>
            {title}
          </h4>
        )}

        <p className={`mb-6 py-8 text-center font-medium text-greySecondary`}>
          {bodyText}
        </p>
        {/* {loading && (
          <div className="absolute top-0 left-0 w-full h-full !bg-[#ffffff95] flex justify-center items-center">
            <Spin size="large" fullscreen={true} className="" />
          </div>
        )} */}
      </div>
      <div className="flex justify-between border-t-2 border-greyStroke px-10 py-6">
        <Button
          variant="gray"
          onClick={() => {
            onClose();
          }}
        >
          Cancel
        </Button>
        <Button variant="primary" onClick={handleProceed}>
          {loading ? `${buttonText}...` : buttonText}
        </Button>
      </div>
    </div>
  );
};

export default Prompt;
