import Image from "next/image";
import React from "react";
import AlertIcon from "@/assets/icons/icons8-alert.gif";

const AlertPrompt = ({ body }: { body: string }) => {
  return (
    <div className="w-[300px] rounded-lg bg-white p-10">
      <div className="flex justify-center">
        <Image src={AlertIcon} alt="alert" className="h-[100px] w-[100px]" />
      </div>
      <div className="relative">
        <p className="pb-8 pt-4 text-center text-lg font-medium text-greySecondary">
          {body}
        </p>
      </div>
    </div>
  );
};

export default AlertPrompt;
