import React from "react";

interface Props {
  title: string;
  body: string;
}

const PageHeader = ({ title, body }: Props) => {
  return (
    <div className="rounded-[14px] border border-greyStroke bg-whiteShade p-4 text-grey">
      <h4 className="mb-1 text-[18px] font-semibold sm:text-[20px]">{title}</h4>
      <span className="text-sm font-medium text-grey sm:text-[16px]">
        {body}
      </span>
    </div>
  );
};

export default PageHeader;
