import React, { useState } from "react";
import { Button } from "../Buttons";
import { useDispatch } from "react-redux";
import { AppDispatch } from "@/redux/store";
import { logout } from "@/redux/user/userSlice";
import Loading from "../Loading/Loading";
import { useRouter } from "next/navigation";
import { togglePopup } from "@/redux/global/globalSlice";

const Logout = () => {
  const reduxDispatch = useDispatch<AppDispatch>();
  const router = useRouter();
  const [isLoading, setIsLoading] = useState<boolean>(false);

  const onHandleLogout = () => {
    setIsLoading(true);
    setTimeout(() => {
      reduxDispatch(logout());
      router.push("/auth/login");
      reduxDispatch(togglePopup({ key: "secondPopup", isOpen: false }));
      setIsLoading(false);
    }, 2000);
  };

  return (
    <div className="relative w-[80vw] overflow-hidden rounded-lg bg-white px-8 py-10 sm:w-[400px]">
      {isLoading && (
        <Loading
          className={{
            body: "bg-black/25",
            loader: "!w-[40px]",
          }}
        />
      )}
      <div>
        <p className="mb-6 py-8 text-center text-xl font-medium text-grey">
          Are you sure you want to log out?
        </p>
      </div>
      <div className="mx-auto max-w-[300px]">
        <Button onClick={onHandleLogout} variant="primary" className="w-full">
          Logout{" "}
        </Button>
      </div>
    </div>
  );
};

export default Logout;
