"use client";

import React, { useState } from "react";
import { AppDispatch, RootState } from "@/redux/store";
import { setUserContacts } from "@/redux/user/userSlice";
import institutionService from "@/services/institution.service";
import toast from "react-hot-toast";
import { useDispatch, useSelector } from "react-redux";

const useContacts = () => {
  const reduxDispatch = useDispatch<AppDispatch>();

  const [isLoading, setIsLoading] = useState<boolean>(false);

  const { activeInstitution } = useSelector((state: RootState) => state.user);

  const onGetContacts = async () => {
    if (activeInstitution) {
      setIsLoading(true);
      institutionService
        .getInstitutionContacts({
          institutionId: activeInstitution.id,
        })
        .then((res) => {
          console.log(res);
          reduxDispatch(setUserContacts(res?.data as unknown[]));
        })
        .catch((error) => {
          console.log(error);
          toast.error(error?.message || error?.errors);
        })
        .finally(() => {
          setIsLoading(false);
        });
    }
  };
  return { isLoading, onGetContacts };
};

export default useContacts;
