import { Button } from "@/components/Buttons";
import { TextInput } from "@/components/Inputs";
import { togglePopup } from "@/redux/global/globalSlice";
import { AppDispatch } from "@/redux/store";
import { MANAGE_CONTACT_SCHEMA } from "@/utils/validationSchema/common.schema";
import { Form, Formik } from "formik";
import React from "react";
import { useDispatch } from "react-redux";

interface FormValues {
  name: string;
  email: string;
}

const ManageContacts = () => {
  const reduxDispatch = useDispatch<AppDispatch>();

  const initialValues: FormValues = {
    email: "",
    name: "",
  };
  return (
    <div className="flex h-[500px] w-[80vw] flex-col rounded-lg bg-white sm:w-[500px]">
      <div className="mb-3 px-3 pb-3 pt-8 text-center shadow-sm sm:px-8">
        <span className="text-xl font-semibold text-grey">Add New Contact</span>
      </div>
      <div className="relative flex flex-1 flex-col overflow-auto px-3 pb-4 pt-2 sm:px-8">
        <Formik
          initialValues={initialValues}
          validationSchema={MANAGE_CONTACT_SCHEMA}
          onSubmit={(values) => console.log(values)}
        >
          {() => (
            <Form className="mt-5 space-y-4" id="manageContactForm">
              <TextInput
                name="name"
                type="text"
                label="Name"
                //   disabled={isLoading}
              />
              <TextInput
                name="email"
                type="email"
                label="Email Address"
                //   disabled={isLoading}
              />
            </Form>
          )}
        </Formik>

        {/* <p className="my-4 text-center text-sm text-grey">OR</p>

        <Button variant="secondary" className="w-fit self-center">
          Import a list of Pathologist
        </Button> */}
      </div>
      <div className="flex w-full justify-between border-t-2 border-greyStroke px-3 py-6 sm:px-8">
        <Button
          variant="gray"
          type="button"
          onClick={() =>
            reduxDispatch(togglePopup({ key: "firstPopup", isOpen: false }))
          }
        >
          Cancel
        </Button>
        <Button
          variant="primary"
          type="submit"
          form="manageContactForm"
          // loading={isLoading}
        >
          Send Invite
        </Button>
      </div>
    </div>
  );
};

export default ManageContacts;
