import { Button } from "@/components/Buttons";
import { ActionDropdown } from "@/components/Dropdowns/ActionDropdown";
import { TextInput } from "@/components/Inputs";
import { setPopupChildren, togglePopup } from "@/redux/global/globalSlice";
import { AppDispatch, RootState } from "@/redux/store";
import { getInitials } from "@/utils/utilities";
import { Form, Formik } from "formik";
import React, { useEffect, useState } from "react";
import toast from "react-hot-toast";
import {
  MdOutlineAddIcCall,
  MdOutlineCalendarToday,
  MdOutlineChat,
  MdOutlineDelete,
  MdOutlineMoreVert,
  MdSubdirectoryArrowRight,
} from "react-icons/md";
import { useDispatch, useSelector } from "react-redux";
import useContacts from "./hooks/useContacts";
import { User } from "@/interfaces";

const Contacts = () => {
  const reduxDispatch = useDispatch<AppDispatch>();

  const { contacts } = useSelector((state: RootState) => state.user);

  const { isLoading, onGetContacts } = useContacts();

  const [filteredData, setFilteredData] = useState(contacts);

  useEffect(() => {
    if (!contacts.length) onGetContacts();
  }, []);

  useEffect(() => {
    setFilteredData(contacts);
  }, [contacts]);

  console.log("=====", contacts);

  const onSearch = (
    event: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>,
  ) => {
    const lowerCaseText = event.target.value.toLowerCase();
    if (!event) {
      setFilteredData(contacts);
      return;
    }
    // const filteredItems = contacts?.filter((item) => {
    //   const firstName = item?.toLowerCase();
    //   const lastName = item?.toLowerCase();

    //   return (
    //     (firstName && firstName.includes(lowerCaseText)) ||
    //     (lastName && lastName.includes(lowerCaseText))
    //   );
    // });

    // setFilteredData(filteredItems);
  };

  const onAddContact = () => {
    reduxDispatch(
      setPopupChildren({
        key: "firstPopup",
        componentKey: "manageContact",
      }),
    );
    reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  };

  return (
    <div className="relative flex h-full flex-col px-4">
      <p className="py-3 text-center text-xl font-semibold text-grey">
        Contacts
      </p>
      {isLoading ? (
        <div className="mb-0 flex flex-1 items-center justify-center">
          <p className="px-4 text-center text-sm text-greySecondary">
            Loading your contacts...
          </p>
          <div className="loader"></div>
        </div>
      ) : contacts.length > 0 ? (
        <>
          <div className="pt-3">
            <Formik
              initialValues={{ search: "" }}
              onSubmit={(values) => console.log(values)}
            >
              {() => (
                <Form>
                  <TextInput
                    name="search"
                    type="search"
                    onChange={(e) => onSearch(e)}
                    placeholder="Search your contacts"
                  />
                </Form>
              )}
            </Formik>
          </div>

          <ul className="mb-0 mt-4 h-[60%] overflow-y-auto rounded-[4px] border border-greyStroke px-4 py-4">
            <p className="font-medium text-greySecondary">Contact List</p>
            {(filteredData as User[])?.map((user, i) => (
              <li
                key={i}
                className="my-3 flex flex-row items-center justify-between"
              >
                <div className="inline-flex items-center gap-2">
                  <span className="flex size-10 items-center justify-center rounded-full bg-primaryMain p-1 text-center text-[16px] font-medium text-whiteShade">
                    {getInitials(`${user?.firstName} ${user?.lastName}`)}
                  </span>
                  <div className="flex flex-col justify-center">
                    <span className="font-medium capitalize text-grey">
                      {user?.firstName || " "} {user?.lastName || " "}
                    </span>
                    {/* <span className="text-sm font-normal text-greySecondary">
                      {"No message history"}
                    </span> */}
                  </div>
                </div>
                <div className="flex flex-row items-center justify-evenly gap-3 overflow-hidden align-middle">
                  <Button
                    variant="icon"
                    onClick={() => toast("Coming Soon!!!")}
                  >
                    <MdOutlineChat size={18} className="text-[#07BC0C]" />
                  </Button>

                  {/* <ActionDropdown
                    theme="primary"
                    align="end"
                    className={{
                      content: "w-fit bg-greyStroke",
                      item: "hover:bg-white",
                    }}
                    trigger={
                      <div className="flex justify-center">
                        <MdOutlineMoreVert />
                      </div>
                    }
                    options={[
                      {
                        label: <div>Remove</div>,
                        onClick: () => console.log("remove"),
                        icon: <MdOutlineDelete />,
                      },
                    ]}
                  /> */}
                </div>
              </li>
            ))}
          </ul>
        </>
      ) : (
        <div className="mb-0 flex flex-1 flex-col items-center justify-center overflow-y-auto pt-3">
          <p className="px-4 text-center text-sm text-greySecondary">
            You do not have any contact yet. All your contacts will appear here.
          </p>
        </div>
      )}

      <div className="absolute bottom-3 right-5 flex flex-col gap-3">
        {
          <Button
            onClick={() => toast("Coming Soon!!!")}
            variant="primary"
            className="justify-cente flex size-[50px] items-center rounded-full p-0"
          >
            <MdOutlineCalendarToday size={20} />
          </Button>
        }

        {
          <Button
            onClick={onAddContact}
            variant="primary"
            className="justify-cente flex size-[50px] items-center rounded-full p-0"
          >
            <MdOutlineAddIcCall size={20} />
          </Button>
        }

        {
          <Button
            onClick={() => toast("Coming Soon!!!")}
            variant="primary"
            className="justify-cente flex size-[50px] items-center rounded-full p-0"
          >
            <MdSubdirectoryArrowRight size={20} />
          </Button>
        }
      </div>
    </div>
  );
};

export default Contacts;
