"use client";

import React from "react";
import Image from "next/image";
import { getInitials } from "@/utils/utilities";

const AccountSelectTab = ({
  onClick,
  role,
  accountName = "No Name",
  logo,
  isLoading,
}: {
  onClick: () => void;
  role: string;
  accountName: string;
  logo?: string | null;
  isLoading?: boolean;
}) => {
  return (
    <div
      className="flex size-[200px] cursor-pointer flex-col items-center justify-center gap-3 overflow-hidden rounded-md border border-greyStroke bg-lightGreenLightest p-[10px] text-sm font-semibold text-primary transition-all duration-300 ease-in-out hover:scale-95 hover:border-primary"
      onClick={onClick}
    >
      <p className="mb-0">{role}</p>

      {logo ? (
        <Image
          className="mx-auto size-[80px] rounded-full object-cover shadow-lg"
          src={logo}
          alt="institution logo"
          width={70}
          height={70}
          crossOrigin="anonymous"
        />
      ) : (
        <div className="mx-auto flex size-[80px] items-center justify-center overflow-hidden rounded-full bg-white object-cover text-3xl text-primary shadow-lg">
          {getInitials(accountName)}
        </div>
      )}

      <p className="mb-0 flex-none truncate">
        <span> {isLoading ? `Setting up...` : accountName} </span>
      </p>
    </div>
  );
};

export default AccountSelectTab;
