import React from "react";
import doctorIcon from "@/assets/icons/doctor-icon.svg";
import hospitalIcon from "@/assets/icons/hospital-icon.svg";
import Image from "next/image";
import { useRouter } from "next/navigation";
import { useDispatch } from "react-redux";
import { AppDispatch } from "@/redux/store";
import { togglePopup } from "@/redux/global/globalSlice";

const CreateAccountTypes = () => {
  const router = useRouter();
  const reduxDispatch = useDispatch<AppDispatch>();

  return (
    <div className="relative w-[600px] overflow-hidden rounded-[40px] border-border bg-whiteShade">
      <div className="absolute -left-[1685px] bottom-[200px] z-0 h-[4000px] w-[4000px] rounded-[100%] bg-lightGreenLight"></div>

      <div className="relative">
        <p className="pt-6 text-center text-[20px] font-medium text-grey">
          Select a role to personalize your experience
        </p>

        <div className="hover-group my-10 flex justify-center gap-10">
          <div
            onClick={() => {
              router.push("/auth/pathologist-register");
              reduxDispatch(togglePopup({ key: "firstPopup", isOpen: false }));
            }}
            className="shrinkable cursor-pointer"
          >
            <figure className="flex h-[120px] w-[120px] items-center justify-center overflow-hidden rounded-full border border-greyStroke transition-all duration-300 ease-in-out hover:bg-lightGreen">
              <Image
                src={doctorIcon}
                alt="doctot-icon"
                className="h-[60%] w-[60%] object-cover"
              />
            </figure>
            <p className="text-center text-[14px] font-semibold text-greySecondary">
              Specialist/Pathologist
            </p>
          </div>
          <div
            onClick={() => {
              router.push("/auth/register");
              reduxDispatch(togglePopup({ key: "firstPopup", isOpen: false }));
            }}
            className="shrinkable cursor-pointer"
          >
            <figure className="flex h-[120px] w-[120px] items-center justify-center overflow-hidden rounded-full border border-greyStroke transition-all duration-300 ease-in-out">
              <Image
                src={hospitalIcon}
                alt="doctot-icon"
                className="h-[60%] w-[60%] object-cover"
              />
            </figure>
            <p className="text-center text-[14px] font-semibold text-greySecondary">
              Hospital/Institution
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default CreateAccountTypes;
