import {
  Tabs as Root,
  TabsContent,
  TabsList,
  TabsTrigger,
} from "@/components/ui/tabs";
import React, { ReactNode } from "react";
import { IconType } from "react-icons/lib";

interface TabProps {
  data: {
    trigger: ReactNode;
    value: string;
    count?: number;
    children: ReactNode | null;
    icon?: IconType;
  }[];
}
export default function AppTabs({ data }: TabProps) {
  return (
    <Root defaultValue={data[0].value} className="w-full overflow-hidden">
      <TabsList className="no-scrollbar h-fit w-full justify-start overflow-x-auto rounded-[56px] bg-greyFill p-3">
        {data.map((item, idx) => {
          return (
            <React.Fragment key={`${item}${idx}`}>
              <TabsTrigger
                className="flex gap-2 rounded-[28px] px-4 py-3 text-base text-grey data-[state=active]:bg-primaryMain data-[state=active]:text-whiteShade"
                value={item.value}
              >
                {item.icon && <item.icon size={18} />}
                {item.trigger} {item.count && item.count}
              </TabsTrigger>
            </React.Fragment>
          );
        })}
      </TabsList>
      {data.map((item, idx) => (
        <TabsContent
          className="h-full w-full"
          key={`${item}${idx}`}
          value={item.value}
        >
          {item.children}
        </TabsContent>
      ))}
    </Root>
  );
}
