import React from "react";
import { Button } from "../Buttons";
import Image from "next/image";
import RecordIcon from "@/assets/icons/screenshot-icon.svg";
import {
  MdCancel,
  MdDownload,
  MdOutlineAddIcCall,
  MdOutlineScreenshotMonitor,
} from "react-icons/md";
import toast from "react-hot-toast";
import useScreenTools from "@/hooks/useScreenTools";
import { BsRecordCircle } from "react-icons/bs";
import { useDispatch, useSelector } from "react-redux";
import { AppDispatch, RootState } from "@/redux/store";
import { setSideBarClosed } from "@/redux/global/globalSlice";

const SideFooter = () => {
  const reduxDispatch = useDispatch<AppDispatch>();
  const { sideBarClosed } = useSelector((state: RootState) => state.global);

  const {
    onStartScreenRecording,
    handleStopRecording,
    downloadScreenRecording,
    recording,
    imageFile,
    videoFile,
    isCaptured,
    mediaElementRef,
    removeFile,
    downloadScreenshot,
    handleScreenshot,
  } = useScreenTools();

  const handleContextMenu = (event: React.MouseEvent<HTMLDivElement>) => {
    event.preventDefault();
  };
  return (
    <>
      <footer
        className={`relative flex items-center justify-center px-[30px] py-[10px] transition-all duration-500 ease-in-out lg:py-[20px] ${sideBarClosed ? "hidden" : ""}`}
      >
        {isCaptured && (
          <div
            className="bottom-30 bot absolute bottom-[100px] left-0 z-30 w-96 rounded-[14px] border border-primary bg-[#27272b] p-5"
            onContextMenu={handleContextMenu}
          >
            {videoFile && (
              <video
                width="100%"
                height="100%"
                className="border border-primary"
                ref={mediaElementRef}
                controls
              >
                <source src={URL.createObjectURL(videoFile)} type="video/mp4" />
              </video>
            )}
            {imageFile && (
              <Image
                height={300}
                width={300}
                className="h-full w-full border border-primary"
                src={imageFile}
                alt="screenshot"
              />
            )}
            <div className="relative flex w-full justify-between pt-2">
              {imageFile && (
                <Button
                  variant="primary"
                  onClick={() => {
                    downloadScreenshot();
                  }}
                >
                  <MdDownload />
                </Button>
              )}
              {videoFile && (
                <Button
                  variant="primary"
                  onClick={() => {
                    downloadScreenRecording();
                  }}
                >
                  <MdDownload />
                </Button>
              )}
              {(imageFile || videoFile) && (
                <Button
                  className="border-1 dark:text-white87 inline-flex items-center justify-center rounded-full border-solid border-red-500 bg-red-500 px-[20px] py-[5px] text-[14px] font-semibold leading-[22px] text-white hover:bg-white hover:text-red-500"
                  variant="secondary"
                  onClick={() => {
                    removeFile();
                  }}
                >
                  <MdCancel />
                </Button>
              )}
            </div>
          </div>
        )}
        <div className="flex w-fit items-center justify-center gap-4 rounded-2xl bg-grey px-8 py-4">
          {recording ? (
            <Button
              onClick={handleStopRecording}
              variant="secondary"
              className="border-none bg-transparent px-1 hover:bg-transparent"
            >
              <BsRecordCircle
                size={34}
                className="animate-pulse text-[#FF0000]"
              />
            </Button>
          ) : (
            <Button
              onClick={onStartScreenRecording}
              variant="secondary"
              className="border-none bg-transparent px-1 hover:bg-transparent"
            >
              <Image
                src={RecordIcon}
                alt="recordIcon"
                className="h-auto w-[32px]"
              />
            </Button>
          )}
          <Button
            variant="secondary"
            onClick={() => {
              handleScreenshot();
              reduxDispatch(setSideBarClosed(true));
            }}
            className="border-none bg-transparent px-1 text-blackMain hover:bg-transparent"
          >
            <MdOutlineScreenshotMonitor size={34} />
          </Button>
          <Button
            variant="secondary"
            onClick={() => toast("Coming Soon!!!")}
            className="border-none bg-transparent px-1 text-blackMain hover:bg-transparent"
          >
            <MdOutlineAddIcCall size={34} />
          </Button>
        </div>
      </footer>
    </>
  );
};

export default SideFooter;
