"use client";

import React from "react";
import Logo from "@/assets/svg/xo-bridge-white-v3.svg";
import ArrowSvg from "@/assets/icons/menu-arrow.svg";
import Image from "next/image";
import {
  MdOutlineContacts,
  MdOutlineDashboard,
  MdOutlineLogout,
  MdOutlineSettings,
  // MdOutlineSummarize,
  MdOutlineTableChart,
} from "react-icons/md";
import { GoDotFill } from "react-icons/go";
import { usePathname } from "next/navigation";

import MenuItems from "./MenuItems";
import SideFooter from "./SideFooter";
import { AppDispatch, RootState } from "@/redux/store";
import { useDispatch, useSelector } from "react-redux";
import {
  setPopupChildren,
  setSideBarClosed,
  togglePopup,
} from "@/redux/global/globalSlice";
import { useIsMobile } from "@/hooks/use-mobile";
import { IoMdSwitch } from "react-icons/io";

const SideBar = () => {
  const pathname = usePathname();
  const reduxDispatch = useDispatch<AppDispatch>();

  const mainPath = pathname.split("/")[2];

  const { activeRole } = useSelector((state: RootState) => state.user);
  const { sideBarClosed } = useSelector((state: RootState) => state.global);

  const isMobile = useIsMobile();

  const handleLogout = () => {
    reduxDispatch(
      setPopupChildren({
        key: "secondPopup",
        componentKey: "logout",
      }),
    );
    reduxDispatch(togglePopup({ key: "secondPopup", isOpen: true }));
  };

  const getMenuItems = () => {
    switch (activeRole) {
      case "ADMIN":
      case "SUPERADMIN":
        return [
          <MenuItems
            key="dashboard"
            icon={<MdOutlineDashboard size={22} />}
            label="Dashboard"
            to="/institution/dashboard"
            isActive={mainPath === "dashboard"}
            onClick={() =>
              isMobile ? reduxDispatch(setSideBarClosed(true)) : null
            }
          />,
          <MenuItems
            key="studies"
            icon={<MdOutlineTableChart size={22} />}
            label="Studies"
            isChildActive={
              mainPath === "view-studies" || mainPath === "upload-studies"
            }
          >
            <MenuItems
              label="View Studies"
              icon={<GoDotFill />}
              to="/institution/view-studies"
              isActive={mainPath === "view-studies"}
              onClick={() =>
                isMobile ? reduxDispatch(setSideBarClosed(true)) : null
              }
            />
            <MenuItems
              label="Upload Studies"
              icon={<GoDotFill />}
              to="/institution/upload-studies"
              isActive={mainPath === "upload-studies"}
              onClick={() =>
                isMobile ? reduxDispatch(setSideBarClosed(true)) : null
              }
            />
          </MenuItems>,
          <MenuItems
            key="pathologists"
            icon={<MdOutlineContacts size={22} />}
            label="Pathologists"
            to="/institution/pathologists"
            isActive={mainPath === "pathologists"}
            onClick={() =>
              isMobile ? reduxDispatch(setSideBarClosed(true)) : null
            }
          />,
        ];

      case "PATHOLOGIST":
        return [
          <MenuItems
            key="studies"
            icon={<MdOutlineTableChart size={22} />}
            label="Studies"
            isChildActive={
              mainPath === "view-studies" || mainPath === "upload-studies"
            }
          >
            <MenuItems
              label="View Studies"
              icon={<GoDotFill />}
              to="/institution/view-studies"
              isActive={mainPath === "view-studies"}
              onClick={() =>
                isMobile ? reduxDispatch(setSideBarClosed(true)) : null
              }
            />
            <MenuItems
              label="Upload Studies"
              icon={<GoDotFill />}
              to="/institution/upload-studies"
              isActive={mainPath === "upload-studies"}
              onClick={() =>
                isMobile ? reduxDispatch(setSideBarClosed(true)) : null
              }
            />
            <MenuItems
              key="switch-account"
              icon={<IoMdSwitch size={22} />}
              label="Switch Account"
              to="/auth/account-select"
              onClick={() =>
                isMobile ? reduxDispatch(setSideBarClosed(true)) : null
              }
            />
          </MenuItems>,
        ];

      default:
        return [];
    }
  };

  const commonItems = [
    // <MenuItems
    //   key="viewer"
    //   icon={<MdOutlineViewTimeline size={22} />}
    //   label="Test Viewer"
    //   to="/institution/view-studies/6vbb2d55/viewer/6vbb2d5"
    //   onClick={() => reduxDispatch(setSideBarClosed(true))}
    // />,
    // <MenuItems
    //   key="template"
    //   icon={<MdOutlineSummarize size={22} />}
    //   label="Reports Template"
    //   to="#"
    //   isActive={mainPath === "template"}
    //        onClick={() => reduxDispatch(setSideBarClosed(true))}

    // />,
    <MenuItems
      key="settings"
      icon={<MdOutlineSettings size={22} />}
      label="Settings"
      isActive={mainPath === "settings"}
      to="/institution/settings/profile"
      onClick={() => (isMobile ? reduxDispatch(setSideBarClosed(true)) : null)}
    />,
    <MenuItems
      key="logout"
      icon={<MdOutlineLogout size={22} />}
      label="Log Out"
      to="#"
      onClick={handleLogout}
    />,
  ];

  return (
    <section
      className={`fixed top-0 h-full max-lg:z-20 lg:relative ${
        sideBarClosed
          ? "w-[280px] max-lg:left-[-100%] lg:!w-[75px]"
          : "w-[280px] max-lg:left-[0%] lg:!w-[280px]"
      } flex flex-col bg-blackMain transition-all duration-500 ease-in-out`}
    >
      <header
        className={`flex h-[80px] items-center py-[20px] ${sideBarClosed ? "justify-center px-[10px]" : "justify-between px-[30px]"}`}
      >
        <Image
          src={Logo}
          alt="logo"
          priority
          loading="eager"
          className={`h-[41px] w-[135px] object-contain transition-all duration-500 ease-in-out ${sideBarClosed ? "hidden" : ""}`}
        />
        <span
          onClick={() => reduxDispatch(setSideBarClosed(!sideBarClosed))}
          className={`flex size-[32px] cursor-pointer items-center justify-center rounded-full transition-all duration-500 ease-in-out ${sideBarClosed ? "" : "rotate-180"}`}
        >
          <Image
            src={ArrowSvg}
            priority
            alt="arrow"
            className="h-full w-auto"
          />
        </span>
      </header>
      <ul
        className={`flex-1 space-y-2 py-[30px] transition-all duration-500 ease-in-out ${sideBarClosed ? "pl-[10px]" : "pl-[30px]"}`}
      >
        {getMenuItems()}
        {commonItems}
      </ul>
      <SideFooter />
    </section>
  );
};

export default SideBar;
