"use client";

import React from "react";
import Logo from "@/assets/svg/xo-bridge-white-v3.svg";
import ArrowSvg from "@/assets/icons/menu-arrow.svg";
import Image from "next/image";
import {
  MdOutlineDashboard,
  MdOutlineLogout,
  MdOutlineSettings,
  MdOutlineSummarize,
  MdOutlineTableChart,
} from "react-icons/md";
import { GoDotFill } from "react-icons/go";
import { usePathname } from "next/navigation";

import MenuItems from "./MenuItems";
import SideFooter from "./SideFooter";
import { AppDispatch, RootState } from "@/redux/store";
import { useDispatch, useSelector } from "react-redux";
import {
  setPopupChildren,
  setSideBarClosed,
  togglePopup,
} from "@/redux/global/globalSlice";
import { useIsMobile } from "@/hooks/use-mobile";
import { IoMdSwitch } from "react-icons/io";

const PersonalSideBar = () => {
  const pathname = usePathname();
  const reduxDispatch = useDispatch<AppDispatch>();

  const mainPath = pathname.split("/")[2];

  const { sideBarClosed } = useSelector((state: RootState) => state.global);

  const isMobile = useIsMobile();

  const handleLogout = () => {
    reduxDispatch(
      setPopupChildren({
        key: "secondPopup",
        componentKey: "logout",
      }),
    );
    reduxDispatch(togglePopup({ key: "secondPopup", isOpen: true }));
  };
  return (
    <section
      className={`fixed top-0 h-full max-lg:z-20 lg:relative ${
        sideBarClosed
          ? "w-[280px] max-lg:left-[-100%] lg:!w-[75px]"
          : "w-[280px] max-lg:left-[0%] lg:!w-[280px]"
      } flex flex-col bg-blackMain transition-all duration-500 ease-in-out`}
    >
      <header
        className={`flex h-[80px] items-center py-[20px] ${sideBarClosed ? "justify-center px-[10px]" : "justify-between px-[30px]"}`}
      >
        <Image
          src={Logo}
          alt="logo"
          priority
          className={`h-[41px] w-[135px] object-contain transition-all duration-500 ease-in-out ${sideBarClosed ? "hidden" : ""}`}
        />
        <span
          onClick={() => reduxDispatch(setSideBarClosed(!sideBarClosed))}
          className={`flex size-[32px] cursor-pointer items-center justify-center rounded-full transition-all duration-500 ease-in-out ${sideBarClosed ? "" : "rotate-180"}`}
        >
          <Image
            src={ArrowSvg}
            priority
            alt="arrow"
            className="h-full w-auto"
          />
        </span>
      </header>
      <ul
        className={`flex-1 space-y-2 py-[30px] transition-all duration-500 ease-in-out ${sideBarClosed ? "pl-[10px]" : "pl-[30px]"}`}
      >
        <MenuItems
          icon={<MdOutlineDashboard size={22} />}
          label="Dashboard"
          to="/personal/dashboard"
          isActive={mainPath === "dashboard"}
          onClick={() =>
            isMobile ? reduxDispatch(setSideBarClosed(true)) : null
          }
        />
        <MenuItems
          icon={<MdOutlineTableChart size={22} />}
          label="Studies"
          isChildActive={
            mainPath === "view-studies" || mainPath === "upload-studies"
          }
        >
          <MenuItems
            label="View Studies"
            icon={<GoDotFill />}
            to="/personal/view-studies"
            isActive={mainPath === "view-studies"}
            onClick={() =>
              isMobile ? reduxDispatch(setSideBarClosed(true)) : null
            }
          />
          <MenuItems
            label="Upload Studies"
            icon={<GoDotFill />}
            to="/personal/upload-studies"
            isActive={mainPath === "upload-studies"}
            onClick={() =>
              isMobile ? reduxDispatch(setSideBarClosed(true)) : null
            }
          />
        </MenuItems>

        <MenuItems
          icon={<MdOutlineSummarize size={22} />}
          label="Report Template"
          isActive={mainPath === "templates"}
          to="#"
          onClick={() =>
            isMobile ? reduxDispatch(setSideBarClosed(true)) : null
          }
        />
        <MenuItems
          icon={<MdOutlineSettings size={22} />}
          label="Settings"
          to="/personal/settings/profile"
          isActive={mainPath === "settings"}
          onClick={() =>
            isMobile ? reduxDispatch(setSideBarClosed(true)) : null
          }
        />

        <MenuItems
          icon={<IoMdSwitch size={22} />}
          label="Switch Account"
          to="/auth/account-select"
          onClick={() =>
            isMobile ? reduxDispatch(setSideBarClosed(true)) : null
          }
        />
        <MenuItems
          icon={<MdOutlineLogout size={22} />}
          label="Log Out"
          to="#"
          onClick={handleLogout}
        />
      </ul>
      <SideFooter />
    </section>
  );
};

export default PersonalSideBar;
