import React from "react";
import { Dialog, DialogContent, DialogHeader, DialogTitle } from "../ui/dialog";

export default function SecondPopup({
  children,
  isOpen = false,
  handleIsOpen,
  closeOnOverlayClick = true,
}: {
  children: React.ReactNode;
  isOpen?: boolean;
  handleIsOpen: () => void;
  closeOnOverlayClick?: boolean;
}) {
  return (
    <Dialog open={isOpen} onOpenChange={handleIsOpen}>
      <DialogHeader>
        <DialogTitle></DialogTitle>
      </DialogHeader>
      <DialogContent
        className="h-fit w-fit border-0 bg-transparent p-0 outline-none"
        onPointerDownOutside={
          closeOnOverlayClick
            ? undefined
            : (event: any) => {
                const target = event.target as HTMLElement;
                if (!target.closest("button")) {
                  event.preventDefault();
                }
              }
        }
      >
        {children}
      </DialogContent>
    </Dialog>
  );
}
