"use client";
import React from "react";
import Popup from "./Popup";
import { useDispatch } from "react-redux";
import { AppDispatch, RootState } from "@/redux/store";
import { useSelector } from "react-redux";
import SecondPopup from "./SecondPopup";
import { togglePopup } from "@/redux/global/globalSlice";
import CreateAccountTypes from "../auth/CreateAccountTypes";
import Prompt from "../common/Prompts/Prompt";
import ManageSendWhatsapp from "@/app/institution/(components)/ManageSendWhatsapp";
import ManagePathologists from "@/app/institution/(components)/ManagePathologists";
import Logout from "../common/Logout";
import ManageContacts from "../common/Contacts/ManageContacts";
import SuccessPrompt from "../common/Prompts/SuccessPrompt";
import AlertPrompt from "../common/Prompts/AlertPrompt";
import PreviewReport from "@/app/institution/view-studies/[studyId]/(components)/PreviewReport";
import PreviewReportPersonal from "@/app/personal/view-studies/[studyId]/(components)/PreviewReport";
import SendForReview from "@/app/institution/(components)/SendForReview";
import ManageUpdateSlide from "@/app/institution/(components)/ManageUpdateSlide";
import RemovePathologist from "../common/Prompts/ReomvePathologist";
import SendToCollegue from "@/app/institution/(components)/SendToCollegue";
import SendToExternalPathologist from "@/app/institution/(components)/SendToExternalPathologist";
import ManageRealTimeView from "@/app/institution/(components)/ManageRealTimeView";
import ManageUpdateSlidePersonal from "@/app/personal/(components)/ManageUpdateSlidePersonal";

export default function PopupContainer() {
  const reduxDispatch = useDispatch<AppDispatch>();
  const { firstPopup, secondPopup, popupChildren } = useSelector(
    (state: RootState) => state.global,
  );

  const renderComponent = (
    componentKey: string,
    componentProps: Record<string, any>,
  ) => {
    switch (componentKey) {
      case "createAccountTypes":
        return <CreateAccountTypes />;
      case "manageSendToWhatsApp":
        return <ManageSendWhatsapp />;
      case "managePathologist":
        return <ManagePathologists />;
      case "managePathologistType":
        return (
          <ManagePathologists pathologist={componentProps.body} isType={true} />
        );
      case "manageContact":
        return <ManageContacts />;
      case "manageUpdateSlide":
        return (
          <ManageUpdateSlide
            slide={componentProps.slide}
            isDetail={componentProps.isDetail}
          />
        );
      case "manageUpdateSlidePersonal":
        return (
          <ManageUpdateSlidePersonal
            slide={componentProps.slide}
            isDetail={componentProps.isDetail}
          />
        );
      case "logout":
        return <Logout />;
      case "prompt":
        return (
          <Prompt
            widthSize={componentProps?.widthSize}
            title={componentProps?.title}
            onClose={() =>
              reduxDispatch(
                togglePopup({ key: componentProps?.onCloseKey, isOpen: false }),
              )
            }
            onProceed={componentProps.onProceed}
            bodyText={componentProps.bodyText}
            buttonText={componentProps.buttonText}
          />
        );
      case "successPrompt":
        return <SuccessPrompt body={componentProps.body} />;
      case "alertPrompt":
        return <AlertPrompt body={componentProps.body} />;
      case "previewReport":
        return <PreviewReport body={componentProps.body} />;
      case "previewReportPersonal":
        return <PreviewReportPersonal body={componentProps.body} />;
      case "sendForReview":
        return <SendForReview body={componentProps.body} />;
      case "sendToColleague":
        return (
          <SendToCollegue
            body={componentProps.body}
            reportId={componentProps.reportId}
          />
        );
      case "sendToExternalPathologist":
        return (
          <SendToExternalPathologist
            body={componentProps.body}
            reportId={componentProps.reportId}
          />
        );
      case "removePathologistPrompt":
        return (
          <RemovePathologist
            widthSize={componentProps?.widthSize}
            onClose={() =>
              reduxDispatch(
                togglePopup({ key: componentProps?.onCloseKey, isOpen: false }),
              )
            }
            user={componentProps.user}
          />
        );
      case "realTImeView":
        return <ManageRealTimeView />;
      default:
        return null;
    }
  };

  return (
    <React.Fragment>
      {/* First Popup  */}
      <Popup
        handleIsOpen={() =>
          reduxDispatch(togglePopup({ key: "firstPopup", isOpen: false }))
        }
        isOpen={firstPopup.isOpen}
        closeOnOverlayClick={firstPopup.closable}
      >
        {renderComponent(
          popupChildren.firstPopup?.componentKey || "",
          popupChildren.firstPopup?.props,
        )}
      </Popup>

      {/* Second Popup  */}
      <SecondPopup
        handleIsOpen={() =>
          reduxDispatch(togglePopup({ key: "secondPopup", isOpen: false }))
        }
        isOpen={secondPopup.isOpen}
        closeOnOverlayClick={secondPopup.closable}
      >
        {renderComponent(
          popupChildren.secondPopup?.componentKey || "",
          popupChildren.secondPopup?.props,
        )}
      </SecondPopup>
    </React.Fragment>
  );
}
