import Image from "next/image";
import React from "react";
import Logo from "@/assets/svg/xo-bridge-v3.svg";

import { getInitials } from "@/utils/utilities";

const ExternalNavbar = () => {
  const navTitle = "";
  return (
    <div className="sticky top-0 z-20 flex w-full items-center justify-center bg-whiteShade shadow-md">
      {/* Large Devices */}
      <div className="flex h-[80px] w-full items-center justify-between px-8 max-lg:hidden">
        <Image
          src={Logo}
          alt="logo"
          priority
          className={`h-[41px] w-[110px] object-contain`}
        />
        <p className="max-w-[50%] truncate text-center text-2xl font-semibold text-blackMain">
          {navTitle}
        </p>

        <div className="flex h-[45px] w-[45px] items-center justify-center overflow-hidden rounded-full bg-primaryMain object-cover font-medium text-whiteShade">
          {getInitials(`Boo Tang`)}
        </div>
      </div>

      {/* Mobile */}
      <div className="flex h-[80px] w-full items-center justify-between px-2 lg:hidden">
        <Image
          src={Logo}
          alt="logo"
          priority
          className={`h-[41px] w-[110px] object-contain`}
        />

        <p className="max-w-[50%] truncate text-xl font-semibold text-blackMain max-sm:hidden">
          {navTitle}
        </p>
        <div className="flex h-[45px] w-[45px] items-center justify-center overflow-hidden rounded-full bg-primaryMain object-cover font-medium text-whiteShade">
          {getInitials(`Boo Tang`)}
        </div>
      </div>
    </div>
  );
};

export default ExternalNavbar;
