import React from "react";
import { cn } from "@/utils/utilities";

export default function Loading({
  loaderText,
  className,
}: {
  className?: {
    body?: string;
    loader?: string;
    loaderText?: string;
  };
  loaderText?: string;
}) {
  return (
    <React.Fragment>
      <div
        className={cn(
          "absolute inset-0 z-40 flex h-full w-full items-center justify-center gap-2 bg-[#e7eaee99]",
          className?.body,
        )}
      >
        <div className={cn("loader", className?.loader)}></div>
        <p className={cn("", className?.loaderText)}>{loaderText}</p>
      </div>
    </React.Fragment>
  );
}
