import Image from "next/image";
import React from "react";

const WhyCard = ({
  title,
  body,
  icon,
  isLastColumn,
  isLastRow,
  singleColumn,
  isCentered,
}: {
  title: string;
  body: string;
  icon: string;
  isLastColumn?: boolean;
  isLastRow?: boolean;
  singleColumn?: boolean;
  isCentered?: boolean;
}) => {
  return (
    <div
      className={`flex h-[250px] items-center justify-center overflow-hidden bg-lightGreenLightest p-6 sm:h-[300px] md:px-6 ${!singleColumn ? (isCentered ? "border-l border-r" : isLastColumn ? "border-l" : "border-r") : ""} ${isLastRow ? "border-t" : "border-b"} border-greyStroke`}
    >
      <div className="rounded-2xl px-0 pb-2 sm:px-3">
        <div className="flex justify-center text-primary">
          <Image src={icon} alt="icon" className="max-sm:scale-75" />
        </div>
        <div className="flex flex-col gap-y-2">
          <h1 className="pt-6 text-center text-xl font-semibold text-grey">
            {title}
          </h1>
        </div>
        <p className="mb-0 text-center text-sm font-normal text-grey sm:text-[17px] sm:text-sm md:text-[16px] lg:text-[16px]">
          {body}
        </p>
      </div>
    </div>
  );
};

export default WhyCard;
