import Image from "next/image";
import React from "react";
import HeartIcon from "@/assets/icons/heatbeat.svg";
import { pathologistFeatureData } from "./constants";
import WhyCard from "./WhyCard";

const Why = () => {
  return (
    <div className="mx-auto max-w-[1440px] px-2 py-20">
      <div className="mb-8 flex flex-col items-center gap-4 text-center">
        <h3 className="mb-0 text-3xl font-semibold text-greySecondary sm:text-[2.5rem]">
          Why Choose Our Platform
        </h3>
        <Image src={HeartIcon} alt="heartbeat" loading="lazy" />
        <p className="text-[1rem] font-medium text-grey sm:text-[1.2rem]">
          We empower you with seamless tele-pathology solutions, featuring
          advanced tools and capabilities.
        </p>
      </div>
      <div className="mx-auto max-w-[1280px] gap-y-2 px-4 py-5 sm:w-full sm:px-5 md:w-full md:px-5 xl:px-0">
        <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3">
          {pathologistFeatureData?.map((item) => {
            return (
              <div key={item.title}>
                <WhyCard title={item.title} body={item.body} icon={item.icon} />
              </div>
            );
          })}
        </div>
      </div>
    </div>
  );
};

export default Why;
