"use client";

import Image from "next/image";
import React from "react";
import hero from "@/assets/img/Diagnostic_Lab.webp";
import { Button } from "../Buttons";
import { useRouter } from "next/navigation";
import { Link } from "react-scroll";

const Hero = () => {
  const router = useRouter();
  return (
    <section id="home">
      <div className="relative h-screen max-h-screen w-screen max-w-full overflow-hidden">
        <Image
          src={hero}
          alt="hero_image"
          className="h-full w-full object-cover"
          priority
        />
        <div className="absolute inset-0 bg-[#011e2180]"></div>
        <div className="absolute left-1/2 top-1/2 z-10 w-full -translate-x-1/2 -translate-y-1/2 px-2 text-center sm:w-3/4">
          <h2 className="mx-auto max-w-[800px] text-[38px] font-semibold leading-[48px] text-whiteShade sm:text-[52px] sm:leading-tight">
            Revolutionizing Pathology,
            <br className="max-sm:hidden" /> Expanding Access to Expert
            Diagnosis
          </h2>
          <p className="mx-auto mt-5 max-w-[600px] text-[18px] font-medium text-greyFill sm:mt-10 sm:text-[20px]">
            Empowering healthcare providers with real-time collaboration, faster
            diagnoses, and access to world-class pathologists—anytime, anywhere.
          </p>
          <div className="mt-6 flex flex-row items-center justify-center gap-3 sm:gap-6">
            <Button
              onClick={() => router.push("/auth/login")}
              variant="primary"
            >
              Get Started
            </Button>
            <Link to="contact" smooth={true} duration={500}>
              <Button variant="secondary">Contact Us</Button>
            </Link>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Hero;
