"use client";

import React from "react";
import { FaLinkedinIn } from "react-icons/fa";
import { IoLogoFacebook } from "react-icons/io5";
import { MdEmail } from "react-icons/md";
import Logo from "@/assets/svg/xo-bridge-v3.svg";
import "./footerStyle.css";
import Link from "next/link";
import { Link as ScrollLink } from "react-scroll";
import Image from "next/image";

const Footer = () => {
  return (
    <section className="bg-whiteShade">
      <div className="landing_footer">
        <div className="landing_foot_top">
          <div className="foot_left_box">
            <Image src={Logo} alt="logo" className="" loading="lazy" />
            <p>
              Connect Instantly with Top Practitioners, Pharmacies, and Labs -
              Wherever You Are.
            </p>

            <div className="flex gap-5 text-greySecondary">
              <Link
                href="mailto:xolanihealth@gmail.com?subject=Hello"
                title="Send an Email"
              >
                <MdEmail size={20} />
              </Link>
              <Link
                href="https://web.facebook.com/xolanihealth"
                target="_blank"
                title="Follow us on Facebook"
              >
                <IoLogoFacebook size={20} />
              </Link>
              <Link
                href="https://www.linkedin.com/company/xolanihealth/posts/?feedView=all"
                target="_blank"
                title="Follow us on LinkedIn"
              >
                <FaLinkedinIn size={20} />
              </Link>
            </div>
          </div>
          <div className="foot_right_box">
            <div className="foot_right_content">
              <h3>Company</h3>
              <div className="max-md:space-x-2 md:space-y-2">
                <p>About Us</p>
                <p>FAQ</p>
                <ScrollLink
                  className="block"
                  to="contact"
                  smooth={true}
                  duration={500}
                >
                  Get in Touch
                </ScrollLink>
              </div>
            </div>
            <div className="foot_right_content">
              <h3>Products</h3>
              <div className="max-md:space-x-2 md:space-y-2">
                <Link
                  href="https://www.telepathology.xolanibridge.com"
                  target="_blank"
                  className="block"
                >
                  Tele-Pathology
                </Link>
                <p>Tele-Medicine</p>
                <Link
                  href="https://www.xolanibridge.com"
                  target="_blank"
                  className="block"
                >
                  Tele-Radiology
                </Link>
              </div>
            </div>

            <div className="foot_right_content">
              <h3>Pricing</h3>
              <div className="max-md:space-x-2 md:space-y-2">
                <p>Pay As You Go</p>
                <p>Monthly Insurance</p>
                <p>By Insurance</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="landing_footer_bottom">
        <div className="landing_foot_bottom">
          <div className="foot_bottom_left">
            <div className="foot_bottom_links">
              {/* <span onClick={() => window.open("/privacy", "_blank")}> */}
              <span>Privacy Policy</span>
              {/* <span onClick={() => window.open("/terms-conditions", "_blank")}> */}
              <span>Terms & Conditions</span>
              <ScrollLink
                className="cursor-pointer"
                to="contact"
                smooth={true}
                duration={500}
              >
                Contact Us
              </ScrollLink>
            </div>
            <p>
              Copyright 2021 - {new Date().getFullYear()}, Xolani Health Inc.
              All rights reserved.
            </p>
          </div>
          <div className="foot_bottom_right">
            <div className="flex gap-5 text-greySecondary">
              <Link
                href="mailto:xolanihealth@gmail.com?subject=Hello"
                title="Send an Email"
              >
                <MdEmail size={20} />
              </Link>
              <Link
                href="https://web.facebook.com/xolanihealth"
                target="_blank"
                title="Follow us on Facebook"
              >
                <IoLogoFacebook size={20} />
              </Link>
              <Link
                href="https://www.linkedin.com/company/xolanihealth/posts/?feedView=all"
                target="_blank"
                title="Follow us on LinkedIn"
              >
                <FaLinkedinIn size={20} />
              </Link>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Footer;
