import React from "react";
import Image from "next/image";
import Featured1 from "@/assets/img/1.webp";
import Featured2 from "@/assets/img/2.webp";
import Featured3 from "@/assets/img/3.webp";
import Featured4 from "@/assets/img/4.webp";
import Featured5 from "@/assets/img/5.webp";
import Featured6 from "@/assets/img/6.webp";

const Featured = () => {
  return (
    <section className="bg-lightGreenLight py-20">
      <div className="mx-auto max-w-[1280px]">
        <div className="mb-8 flex flex-col items-center gap-4 text-center">
          <h3 className="mb-0 text-3xl font-semibold text-greySecondary sm:text-[2.5rem]">
            Featured In
          </h3>
        </div>
        <div className="w-full">
          <div className="flex gap-6 overflow-x-auto md:grid md:grid-cols-6">
            <Image
              src={Featured1}
              alt="featured"
              className="h-[100px] w-[150px] object-contain sm:w-full"
              loading="lazy"
            />
            <Image
              src={Featured2}
              alt="featured"
              className="h-[100px] w-[150px] object-contain sm:w-full"
              loading="lazy"
            />
            <Image
              src={Featured3}
              alt="featured"
              className="h-[100px] w-[150px] object-contain sm:w-full"
              loading="lazy"
            />
            <Image
              src={Featured4}
              alt="featured"
              className="h-[100px] w-[150px] object-contain sm:w-full"
              loading="lazy"
            />
            <Image
              src={Featured5}
              alt="featured"
              className="h-[100px] w-[150px] object-contain sm:w-full"
              loading="lazy"
            />
            <Image
              src={Featured6}
              alt="featured"
              className="h-[100px] w-[150px] object-contain sm:w-full"
              loading="lazy"
            />
          </div>
        </div>
      </div>
    </section>
  );
};

export default Featured;
