import Image from "next/image";
import React from "react";
import aboutImg from "@/assets/img/Diagnostic_Lab.webp";

const AboutUs = () => {
  return (
    <section
      id="about"
      className="flex w-full flex-col justify-center bg-lightGreen px-0 py-10 sm:px-5 sm:py-10 md:px-[20px] lg:px-[50px]"
    >
      <div className="mx-auto flex w-full max-w-[1280px] flex-col justify-between md:flex-row">
        <div className="flex w-full items-center overflow-hidden px-4 md:w-1/2">
          <Image
            className="h-full max-h-[460px] w-full max-w-[520px] object-cover"
            src={aboutImg}
            alt="about"
            loading="lazy"
          />
        </div>
        <div className="flex w-full max-w-[600px] flex-col justify-center p-8 sm:p-10 md:w-1/2 lg:p-4">
          <h1 className="mb-4 text-left text-4xl font-semibold text-grey sm:text-2xl lg:text-[28px]">
            About XolaniBridge
          </h1>
          <h2 className="mb-4 text-left text-lg font-medium text-primary md:text-xl">
            Making Healthcare Accessible, For All, Together
          </h2>
          <p className="text-left text-lg font-medium leading-9 text-greySecondary md:text-lg lg:text-xl">
            At XolaniBridge, we are transforming pathology through cutting-edge
            telepathology solutions. Our platform connects laboratories,
            hospitals, and clinics to a global network of expert pathologists,
            enabling real-time collaboration and precise diagnoses. By
            integrating seamlessly into your workflow, we help reduce turnaround
            times, enhance diagnostic accuracy, and expand access to specialized
            expertise. Whether you're a healthcare provider seeking faster, more
            reliable pathology services or a pathologist looking to collaborate
            globally, XolaniBridge empowers you to deliver life-changing care
            with efficiency and precision.
          </p>
        </div>
      </div>
    </section>
  );
};

export default AboutUs;
