import React from "react";
import Dropdown, { DropdownProps } from "../Dropdowns/DropdownSelect";
import { Field, FieldProps, getIn } from "formik";

interface SelectInputProps
  extends Omit<DropdownProps, "onValueChange" | "value"> {
  name: string;
  label?: string;
}

export const SelectInput = ({ name, label, ...props }: SelectInputProps) => {
  return (
    <Field name={name}>
      {({ field, form }: FieldProps) => {
        const error = getIn(form.errors, field.name);
        const touched = getIn(form.touched, field.name);
        const handleChange = (value: string) => {
          form.setFieldValue(name, value);
        };

        return (
          <div>
            {label && (
              <label
                htmlFor={name}
                className="text-grey text-[12px] font-medium"
              >
                {label}
              </label>
            )}
            <Dropdown
              {...props}
              value={field.value}
              onValueChange={handleChange}
            />
            {touched && error && (
              <p className="mt-1 text-[10px] font-medium text-[#ff0000]">
                {error}
              </p>
            )}
          </div>
        );
      }}
    </Field>
  );
};
