"use client";

import React from "react";
import { Field, FieldProps, getIn } from "formik";
import ReactPhoneInput, {
  isPossiblePhoneNumber,
} from "react-phone-number-input";
import "react-phone-number-input/style.css";

type Props = {
  name: string;
  label?: string;
};

export const PhoneInput = ({ name, label }: Props) => {
  return (
    <Field name={name}>
      {({ field, form }: FieldProps) => {
        const error = getIn(form.errors, field.name);
        const touched = getIn(form.touched, field.name);
        const handleChange = (value: string | undefined) => {
          form.setFieldValue(name, value);

          if (value && !isPossiblePhoneNumber(value)) {
            form.setFieldError(name, "Invalid phone number");
          } else {
            form.setFieldError(name, undefined);
          }
        };
        return (
          <div className="[&>.PhoneInput]:bg-bgInput [&>.PhoneInput>input]:text-[14px] [&>.PhoneInput>input]:text-blackMain [&>.PhoneInput>input]:outline-none [&>.PhoneInput]:h-[40px] [&>.PhoneInput]:rounded-[4px] [&>.PhoneInput]:border [&>.PhoneInput]:border-greyLine [&>.PhoneInput]:px-3">
            {label && (
              <label
                htmlFor={name}
                className="text-[12px] font-medium text-grey"
              >
                {label}
              </label>
            )}
            <ReactPhoneInput
              international
              countryCallingCodeEditable={false}
              defaultCountry="NG"
              value={field.value || ""}
              onChange={handleChange}
            />
            {touched && error && (
              <p className="mt-1 text-[10px] font-medium text-[#ff0000]">
                {error}
              </p>
            )}
          </div>
        );
      }}
    </Field>
  );
};
