"use client";

import React from "react";
import Drawer from "./Drawer";
import { useDispatch, useSelector } from "react-redux";
import { AppDispatch, RootState } from "@/redux/store";
import { setDrawer } from "@/redux/global/globalSlice";
import Report from "@/app/institution/view-studies/[studyId]/(components)/Report/Report";
import PersonalReport from "@/app/personal/view-studies/[studyId]/(components)/Report/Report";
import Contacts from "../common/Contacts/Contacts";
import ExternalReport from "@/app/external/(components)/ExternalReport";

const DrawerContainer = () => {
  const reduxDispatch = useDispatch<AppDispatch>();
  const { drawer, drawerChildren } = useSelector(
    (state: RootState) => state.global,
  );

  const handleClose = () => {
    reduxDispatch(setDrawer({ isOpen: false }));
  };

  const renderComponent = (componentKey: string) => {
    switch (componentKey) {
      case "report":
        return <Report />;

      case "personalReport":
        return <PersonalReport />;
      case "externalReport":
        return <ExternalReport />;
      case "contacts":
        return <Contacts />;

      default:
        return null;
    }
  };
  return (
    <Drawer
      isOpen={drawer.isOpen}
      width={drawer.width}
      closable={drawer.closable}
      onClose={handleClose}
    >
      {renderComponent(drawerChildren?.key || "")}
    </Drawer>
  );
};

export default DrawerContainer;
